



#include <CompuCell3D/Simulator.h>
#include <CompuCell3D/Potts3D/Potts3D.h>
#include <CompuCell3D/Field3D/Field3D.h>
#include <CompuCell3D/Field3D/WatchableField3D.h>
#include <CompuCell3D/Boundary/BoundaryStrategy.h>

#include <CompuCell3D/Potts3D/CellInventory.h>
#include <CompuCell3D/Automaton/Automaton.h>
#include <BasicUtils/BasicString.h>
#include <BasicUtils/BasicException.h>
#include <PublicUtilities/StringUtils.h>

#include <iostream>
#include <string>
#include <algorithm>
#include <set>
#include <map>
#include <math.h>
using namespace CompuCell3D;


#include <iostream>
using namespace std;

#include "uPARinitializerClusterSteppable.h"
#include "ClusterData.h"

uPARinitializerClusterSteppable::uPARinitializerClusterSteppable() : fieldG(0),sim(0),potts(0),xmlData(0),boundaryStrategy(0),automaton(0),cellInventoryPtr(0){}

uPARinitializerClusterSteppable::~uPARinitializerClusterSteppable() {
}


void uPARinitializerClusterSteppable::init(Simulator *simulator, CC3DXMLElement *_xmlData) {

  xmlData=_xmlData;
  
  potts = simulator->getPotts();
  cellInventoryPtr=& potts->getCellInventory();
  automaton = potts->getAutomaton();
  fieldG = (WatchableField3D<CellG *> *)potts->getCellFieldG();

  
  //cerr<<"FuPA="<<FuPA<<endl; 
  simulator->registerSteerableObject(this);
    
     // define a new data-class (clusterData) for each cell:	
    BasicClassAccessorBase * clusterDataAccessorPtr=&clusterDataAccessor;
	potts->getCellFactoryGroupPtr()->registerClass(clusterDataAccessorPtr); //this is to register the BasicclassAccessor to the large factory file

    bool boundaryPixelTrackerAlreadyRegisteredFlag;
    boundaryPixelTrackerPlugin=(BoundaryPixelTrackerPlugin*)Simulator::pluginManager.get("BoundaryPixelTracker",&boundaryPixelTrackerAlreadyRegisteredFlag);
    if (!boundaryPixelTrackerAlreadyRegisteredFlag){
            boundaryPixelTrackerPlugin->init(simulator);
    }
    
    bool pixelTrackerAlreadyRegisteredFlag;
    pixelTrackerPlugin=(PixelTrackerPlugin*)Simulator::pluginManager.get("PixelTracker",&pixelTrackerAlreadyRegisteredFlag);
    if (!pixelTrackerAlreadyRegisteredFlag){
            pixelTrackerPlugin->init(simulator);
    }
    
    bool clusterDataTrackerAlreadyRegisteredFlag;
	clusterDataTrackerPlugin=(ClusterDataTrackerPlugin*)Simulator::pluginManager.get("ClusterDataTrackerPlugin",&clusterDataTrackerAlreadyRegisteredFlag);
	if (!clusterDataTrackerAlreadyRegisteredFlag){
		clusterDataTrackerPlugin->init(simulator,_xmlData);
	}
        
        
        
        
//     bool nTrackerAlreadyRegisteredFlag;
//     nTrackerPlugin=(NeighborTrackerPlugin*)Simulator::pluginManager.get("NeighborTracker",&nTrackerAlreadyRegisteredFlag);
//     if (!nTrackerAlreadyRegisteredFlag){
//             nTrackerPlugin->init(simulator);
//     }
    
    //rand function for probobality funtion, is class
    rand = BasicRandomNumberGenerator::getInstance();

    update(xmlData,true);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void uPARinitializerClusterSteppable::extraInit(Simulator *simulator){
    //PUT YOUR CODE HERE
    FuPAR = simulator->getConcentrationFieldByName("uPARact");
}



void uPARinitializerClusterSteppable::update(CC3DXMLElement *_xmlData, bool _fullInitFlag)
{
    boundaryStrategy=BoundaryStrategy::getInstance();
    //cerr<<"got here will do neighbor order"<<endl;
    if(_xmlData->getFirstElement("NeighborOrder"))
        maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(_xmlData->getFirstElement("NeighborOrder")->getUInt());	
    else
        maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(2);
    

    if(_xmlData->getFirstElement("uPARinitEC"))
        uPARinitEC=_xmlData->getFirstElement("uPARinitEC")->getDouble();
    else
        uPARinitEC=0.0;
    if(_xmlData->getFirstElement("uPARinitPericyte"))
        uPARinitPericyte=_xmlData->getFirstElement("uPARinitPericyte")->getDouble();
    else
        uPARinitPericyte=0.0;
    if(_xmlData->getFirstElement("deltainitEC"))
        deltainitEC=_xmlData->getFirstElement("deltainitEC")->getDouble();
    else
        deltainitEC=0.0;
    if(_xmlData->getFirstElement("notchinitEC"))
        notchinitEC=_xmlData->getFirstElement("notchinitEC")->getDouble();
    else
        notchinitEC=0.0;
    
    if(_xmlData->getFirstElement("VEGFR2initEC"))
        VEGFR2initEC=_xmlData->getFirstElement("VEGFR2initEC")->getDouble();
    else
        VEGFR2initEC=0.0;
    
    if(_xmlData->getFirstElement("randomPercentage"))
        randomPercentage=_xmlData->getFirstElement("randomPercentage")->getDouble();
    else
        randomPercentage=0.0;
    


}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void uPARinitializerClusterSteppable::start(){
    //cerr<<"uPARinitializerClusterSteppable::start=?????????????????"<<endl;
    //initialize uPAR concentartion on pericyte and EC, also initialize list with the pixels in the membrane that need to be updated in step
    set<long int> clusterIdList=clusterDataTrackerPlugin->getClusterIdsList();
    set<long int> ::iterator clusterIdListIt;
    for ( clusterIdListIt=clusterIdList.begin() ; clusterIdListIt != clusterIdList.end(); ++clusterIdListIt )
        {
        
        long int ownClusterId= *clusterIdListIt;
        cerr<<"cell="<<ownClusterId<<endl;   
        if(clusterDataTrackerPlugin->getIfEC(ownClusterId)) //if of type EC
        //if(ownClusterId==10) //if of type EC
            { 
            //set TCS
             double randomN= rand->getRatio(); 
             double initNotch= (((100-randomPercentage)/100)*notchinitEC) + (((((100+randomPercentage)/100)*notchinitEC)-(((100-randomPercentage)/100)*notchinitEC)) *randomN);
             //cerr<<"randomN="<<randomN<<endl;
             double randomD= rand->getRatio(); 
             double initDelta= (((100-randomPercentage)/100)*deltainitEC) + (((((100+randomPercentage)/100)*deltainitEC)-(((100-randomPercentage)/100)*deltainitEC)) *randomD);
             //cerr<<"initNotch="<<initNotch<<"initDelta="<<initDelta<<endl;
             clusterDataTrackerPlugin->setNotchConcentration(ownClusterId,initNotch);  
             //cerr<<"get notch="<<clusterDataTrackerPlugin->getNotchConcentration(ownClusterId)<<endl;
             clusterDataTrackerPlugin->setDeltaConcentration(ownClusterId,initDelta); 
             clusterDataTrackerPlugin->setVEGFR2Concentration(ownClusterId,VEGFR2initEC);  
             clusterDataTrackerPlugin->setuPARConcentration(ownClusterId,uPARinitEC);  
            //set upar
            set<PixelTrackerData> membranePixelListCell;
            membranePixelListCell.clear();        
            membranePixelListCell=clusterDataTrackerPlugin->getBoundaryTrackerList(ownClusterId); 
//             double count=membranePixelListCell.size(); 
//             set<PixelTrackerData>::iterator membranePixelIt;
//             for ( membranePixelIt=membranePixelListCell.begin() ; membranePixelIt != membranePixelListCell.end(); ++membranePixelIt )
//                 {
//                 PixelTrackerData pixelD = *membranePixelIt;  
//                 Point3D pixelData=Point3D(pixelD.pixel);  
//                 //FuPAR->set(pixelData,uPARinitEC/count);
//                 FuPAR->set(pixelData,uPARinitEC);
//                 potts->runSteppers(); 
//                 //break;
//                 }
//             clusterDataTrackerPlugin->setUPARconc(ownClusterId,uPARinitEC); 
            clusterDataTrackerPlugin->setStaticBoundaryTrackerListAtMCS(ownClusterId,membranePixelListCell);
            }
        
        else if(clusterDataTrackerPlugin->getIfPericyte(ownClusterId)) //if of type Pericyte
            {     
            set<PixelTrackerData> membranePixelListCell;
            membranePixelListCell.clear();        
            membranePixelListCell=clusterDataTrackerPlugin->getBoundaryTrackerList(ownClusterId); 
            double count=membranePixelListCell.size();  
            set<PixelTrackerData>::iterator membranePixelIt;
            for ( membranePixelIt=membranePixelListCell.begin() ; membranePixelIt != membranePixelListCell.end(); ++membranePixelIt )
                {
                PixelTrackerData pixelD = *membranePixelIt;  
                Point3D pixelData=Point3D(pixelD.pixel);  
                FuPAR->set(pixelData,uPARinitPericyte);
                potts->runSteppers(); 
                }
            clusterDataTrackerPlugin->setUPARconc(ownClusterId,uPARinitPericyte); 
            clusterDataTrackerPlugin->setStaticBoundaryTrackerListAtMCS(ownClusterId,membranePixelListCell);
            }
        }    
}


void uPARinitializerClusterSteppable::step(const unsigned int currentStep){ 
   
//     set<long int> clusterIdList=clusterDataTrackerPlugin->getClusterIdsList();
//     set<long int> ::iterator clusterIdListIt;
//     for ( clusterIdListIt=clusterIdList.begin() ; clusterIdListIt != clusterIdList.end(); ++clusterIdListIt )
//         {
//         long int ownClusterId= *clusterIdListIt;
//         if(clusterDataTrackerPlugin->getIfEC(ownClusterId)) //if of type EC
//         //if(ownClusterId==10) //if of type EC
//             { 
//             //set TCS
//              //cerr<<"#############################################################################################################################################"<<endl;
//              cerr<< "clusteId="<<ownClusterId<<" [notch]="<<clusterDataTrackerPlugin->getNotchConcentration(ownClusterId)<< " [delta]="<< clusterDataTrackerPlugin->getDeltaConcentration(ownClusterId)<< " [vegfr2]="<<clusterDataTrackerPlugin->getVEGFR2Concentration(ownClusterId)<<endl;                                     
//             }
//         }
                
}



std::string uPARinitializerClusterSteppable::toString(){
   return "uPARinitializerClusterSteppable";
}

std::string uPARinitializerClusterSteppable::steerableName(){
   return toString();
}
        
